/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.item.ItemStaffSummoning;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityPortal
extends EntityProjectileBase {
    private double targetX;
    private double targetY;
    private double targetZ;
    public int summonAmount = 0;
    public int summonTick = 0;
    public int summonTime = 100;
    public double portalRange = 32.0;
    public int summonDuration = 1200;
    public EntityPlayer shootingEntity;
    public Class summonClass;
    public ItemStaffSummoning portalItem;
    public String ownerName;
    public TileEntitySummoningPedestal summoningPedestal;
    protected static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityPortal(World world) {
        super(world);
        this.setStats();
        this.field_70178_ae = true;
    }

    public EntityPortal(World world, EntityPlayer shooter, Class summonClass, ItemStaffSummoning portalItem) {
        super(world, (EntityLivingBase)shooter);
        this.shootingEntity = shooter;
        this.summonClass = summonClass;
        this.portalItem = portalItem;
        this.setStats();
    }

    public EntityPortal(World world, TileEntitySummoningPedestal summoningPedestal) {
        super(world);
        this.summoningPedestal = summoningPedestal;
        this.setStats();
        this.field_70165_t = (double)summoningPedestal.func_174877_v().func_177958_n() + 0.5;
        this.field_70163_u = (double)summoningPedestal.func_174877_v().func_177956_o() + 1.5;
        this.field_70161_v = (double)summoningPedestal.func_174877_v().func_177952_p() + 0.5;
    }

    public void setStats() {
        this.entityName = "summoningportal";
        this.setProjectileScale(6.0f);
        this.moveToTarget();
        this.textureOffsetY = -0.5f;
        this.animationFrameMax = 7;
        this.movement = false;
        this.waterProof = true;
        this.lavaProof = true;
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
    }

    @Override
    public void func_70071_h_() {
        if (this.shootingEntity != null || this.summoningPedestal != null) {
            this.projectileLife = 5;
        }
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.summoningPedestal != null) {
            this.shootingEntity = this.summoningPedestal.getPlayer();
            this.summonClass = this.summoningPedestal.getSummonClass();
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.shootingEntity != null) {
                this.field_70180_af.func_187227_b(OWNER_NAME, (Object)this.shootingEntity.func_70005_c_());
            } else if (this.summoningPedestal != null) {
                this.field_70180_af.func_187227_b(OWNER_NAME, (Object)this.summoningPedestal.getOwnerName());
            } else {
                this.field_70180_af.func_187227_b(OWNER_NAME, (Object)"");
            }
        } else {
            this.ownerName = (String)this.field_70180_af.func_187225_a(OWNER_NAME);
        }
        if (!this.func_130014_f_().field_72995_K && !this.field_70128_L) {
            if (this.summoningPedestal != null) {
                if (this.summonClass == null) {
                    this.func_70106_y();
                    return;
                }
            } else if (this.shootingEntity == null || !this.shootingEntity.func_70089_S() || this.portalItem == null || this.portalItem.portalEntity != this) {
                this.func_70106_y();
                return;
            }
        }
        this.moveToTarget();
        if (this.shootingEntity != null && this.summoningPedestal == null) {
            ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(this.shootingEntity);
            if (playerExt != null && this.portalItem != null && ++this.summonTick >= this.portalItem.getRapidTime(null)) {
                this.summonDuration = this.portalItem.getSummonDuration();
                if (this.shootingEntity.field_71075_bZ.field_75098_d) {
                    this.summonAmount += this.portalItem.getSummonAmount();
                } else {
                    float summonMultiplier = (float)(MobInfo.mobClassToInfo.get((Object)this.summonClass).summonCost + this.portalItem.getSummonCostBoost()) * this.portalItem.getSummonCostMod();
                    int summonCost = Math.round((float)playerExt.summonFocusCharge * summonMultiplier);
                    if (playerExt.summonFocus >= summonCost && this.portalItem.getAdditionalCosts(this.shootingEntity)) {
                        playerExt.summonFocus -= summonCost;
                        this.summonAmount += this.portalItem.getSummonAmount();
                    }
                }
                this.summonTick = 0;
            }
        } else if (this.summonClass != null && ++this.summonTick >= this.summonTime) {
            this.summonAmount = this.summoningPedestal.summonAmount;
            this.summonTick = 0;
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                double angle = Math.toRadians(this.field_70146_Z.nextFloat() * 360.0f);
                float distance = this.field_70146_Z.nextFloat() * 2.0f;
                double x = (double)distance * Math.cos(angle) + Math.sin(angle);
                double z = (double)distance * Math.sin(angle) - Math.cos(angle);
                this.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + x, this.field_70163_u + (double)(4.0f * this.field_70146_Z.nextFloat()) - 2.0, this.field_70161_v + z, 0.0, 0.0, 0.0, new int[0]);
            }
            return;
        }
    }

    public boolean summonCreatures() {
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        if (this.summonClass == null) {
            return false;
        }
        for (int i = 0; i < this.summonAmount; ++i) {
            Entity entity = null;
            try {
                entity = (Entity)this.summonClass.getConstructor(World.class).newInstance(this.func_130014_f_());
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "A none Entity class type was passed to an EntityPortal, only entities can be summoned from portals!");
                e.printStackTrace();
            }
            if (entity == null) {
                return false;
            }
            entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof EntityCreatureBase) {
                EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
                if (this.shootingEntity != null && this.summoningPedestal == null) {
                    entityCreature.setMinion(true);
                    if (entityCreature instanceof EntityCreatureTameable) {
                        ((EntityCreatureTameable)entityCreature).setPlayerOwner(this.shootingEntity);
                        if (this.portalItem != null) {
                            this.portalItem.applyMinionBehaviour((EntityCreatureTameable)entityCreature, this.shootingEntity);
                            this.portalItem.applyMinionEffects(entityCreature);
                        }
                    }
                } else if (this.summoningPedestal != null && this.summoningPedestal.getOwnerUUID() != null) {
                    entityCreature.setMinion(true);
                    if (entityCreature instanceof EntityCreatureTameable) {
                        ((EntityCreatureTameable)entityCreature).setPlayerOwner(this.summoningPedestal.getOwnerUUID(), this.summoningPedestal.getOwnerName());
                        this.summoningPedestal.applyMinionBehaviour((EntityCreatureTameable)entityCreature);
                    }
                }
                if (this.summonDuration > 0) {
                    entityCreature.setTemporary(this.summonDuration);
                }
                if (this.shootingEntity != null) {
                    this.shootingEntity.func_71064_a((StatBase)ObjectManager.getAchievement(entityCreature.mobInfo.name + ".summon"), 1);
                }
            }
            this.func_130014_f_().func_72838_d(entity);
        }
        boolean summonedCreatures = this.summonAmount > 0;
        this.summonAmount = 0;
        return summonedCreatures;
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    public void moveToTarget() {
        if (this.shootingEntity != null && this.summoningPedestal == null) {
            Vec3d lookDirection = this.shootingEntity.func_70040_Z();
            this.targetX = this.shootingEntity.field_70165_t + lookDirection.field_72450_a * this.portalRange;
            this.targetY = this.shootingEntity.field_70163_u + lookDirection.field_72448_b * this.portalRange;
            this.targetZ = this.shootingEntity.field_70161_v + lookDirection.field_72449_c * this.portalRange;
            RayTraceResult target = Utilities.raytrace(this.func_130014_f_(), this.shootingEntity.field_70165_t, this.shootingEntity.field_70163_u, this.shootingEntity.field_70161_v, this.targetX, this.targetY, this.targetZ, 1.0f, null);
            if (target != null && target.field_72307_f != null) {
                this.targetX = target.field_72307_f.field_72450_a;
                this.targetY = target.field_72307_f.field_72448_b;
                this.targetZ = target.field_72307_f.field_72449_c;
            }
            this.targetY += 1.0;
            this.field_70165_t = this.targetX;
            this.field_70163_u = this.targetY;
            this.field_70161_v = this.targetZ;
        }
    }

    public double[] getFacingPosition(Entity entity, double distance) {
        double angle = Math.toRadians(this.field_70177_z);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        double[] coords = new double[]{entity.field_70165_t + distance * xAmount, entity.field_70163_u, entity.field_70161_v + distance * zAmount};
        return coords;
    }

    @Override
    protected void func_70184_a(RayTraceResult movingObjectPos) {
    }

    @Override
    public ResourceLocation getTexture() {
        if (AssetManager.getTexture(this.entityName) == null) {
            AssetManager.addTexture(this.entityName, LycanitesMobs.group, "textures/particles/" + this.entityName.toLowerCase() + ".png");
        }
        if (AssetManager.getTexture(this.entityName + "_client") == null) {
            AssetManager.addTexture(this.entityName + "_client", LycanitesMobs.group, "textures/particles/" + this.entityName.toLowerCase() + "_client.png");
        }
        if (AssetManager.getTexture(this.entityName + "_player") == null) {
            AssetManager.addTexture(this.entityName + "_player", LycanitesMobs.group, "textures/particles/" + this.entityName.toLowerCase() + "_player.png");
        }
        if (this.ownerName != null) {
            if (this.ownerName.equalsIgnoreCase(LycanitesMobs.proxy.getClientPlayer().func_70005_c_())) {
                return AssetManager.getTexture(this.entityName + "_client");
            }
            if (!this.ownerName.equalsIgnoreCase("")) {
                return AssetManager.getTexture(this.entityName + "_player");
            }
        }
        return AssetManager.getTexture(this.entityName);
    }

    @Override
    public float getTextureOffsetY() {
        return this.field_70131_O / 2.0f;
    }
}

